#!/usr/bin/env node

// Cache warming script for faster initial loads
const http = require('http');

const routes = [
  'http://localhost:3003/dashboard',
  'http://localhost:3003/compliance', 
  'http://localhost:3003/findings',
  'http://localhost:3003/reports',
  'http://localhost:3003/api/dashboard',
  'http://localhost:3003/api/compliance/standards',
  'http://localhost:3003/api/findings',
  'http://localhost:3003/api/schedule/staff-compliance'
];

console.log('🔥 Warming up cache for common routes...');

async function warmRoute(url) {
  return new Promise((resolve) => {
    const req = http.get(url, (res) => {
      console.log(`✅ Warmed: ${url} (${res.statusCode})`);
      resolve();
    });
    
    req.on('error', (err) => {
      console.log(`❌ Failed: ${url} (${err.message})`);
      resolve();
    });
    
    req.setTimeout(5000, () => {
      req.destroy();
      console.log(`⏰ Timeout: ${url}`);
      resolve();
    });
  });
}

async function warmAll() {
  console.log('Waiting 10 seconds for server to fully start...');
  await new Promise(resolve => setTimeout(resolve, 10000));
  
  for (const route of routes) {
    await warmRoute(route);
  }
  
  console.log('🚀 Cache warming complete!');
}

warmAll(); 