// Test script to check department model access
const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient({
  log: ['query', 'info', 'warn', 'error'],
});

async function main() {
  try {
    console.log('Testing Department model access...');
    
    // Check if we can access departments directly
    const departments = await prisma.department.findMany({
      take: 5,
    });
    
    console.log(`Found ${departments.length} departments:`, JSON.stringify(departments, null, 2));
    
    // Check schema information
    const tables = await prisma.$queryRaw`SHOW TABLES;`;
    console.log('Database tables:', tables);
    
    // Check department table schema
    const schema = await prisma.$queryRaw`DESCRIBE departments;`;
    console.log('Department table schema:', schema);
    
  } catch (error) {
    console.error('Error testing department model:', error);
  } finally {
    await prisma.$disconnect();
  }
}

main(); 