// This script tests direct database connectivity outside of the Next.js framework
const { PrismaClient } = require('@prisma/client');

async function testDatabaseConnection() {
  console.log('Testing database connection directly...');
  
  const prisma = new PrismaClient({
    log: ['query', 'info', 'warn', 'error'],
  });
  
  try {
    console.log('Attempting to connect to the database...');
    
    // Simple query to test connectivity
    const hospitalCount = await prisma.hospital.count();
    console.log(`Connection successful! Found ${hospitalCount} hospitals.`);
    
    // Get user count
    const userCount = await prisma.user.count();
    console.log(`Found ${userCount} users.`);
    
    // Try to list a sample user
    if (userCount > 0) {
      const sampleUser = await prisma.user.findFirst({
        select: {
          id: true,
          username: true,
          email: true,
          role: true,
          hospital_id: true
        }
      });
      console.log('Sample user:', sampleUser);
    }
    
    return { success: true, hospitalCount, userCount };
  } catch (error) {
    console.error('Database connection failed:', error);
    return { 
      success: false, 
      error: error.message,
      code: error.code,
      meta: error.meta
    };
  } finally {
    await prisma.$disconnect();
  }
}

// Run the test
testDatabaseConnection()
  .then(result => {
    console.log('Test completed:', result);
    if (!result.success) {
      process.exit(1);
    }
  })
  .catch(err => {
    console.error('Unexpected error:', err);
    process.exit(1);
  }); 