const { PrismaClient } = require('@prisma/client');
const { hash } = require('bcrypt');

const prisma = new PrismaClient();

async function main() {
  try {
    console.log('Initializing database with test data...');
    
    // Create hospitals
    console.log('Creating hospitals...');
    const hospital1 = await prisma.hospital.upsert({
      where: { id: 1 },
      update: {},
      create: {
        name: 'City General Hospital',
        location: 'New York, NY',
        logo_url: '/images/hospitals/city-general.png',
      },
    });
    console.log(`Created hospital: ${hospital1.name}`);

    const hospital2 = await prisma.hospital.upsert({
      where: { id: 2 },
      update: {},
      create: {
        name: 'County Medical Center',
        location: 'Los Angeles, CA',
        logo_url: '/images/hospitals/county-medical.png',
      },
    });
    console.log(`Created hospital: ${hospital2.name}`);

    // Create super admin user
    console.log('\nCreating super admin user...');
    const adminPassword = await hash('admin123', 10);
    const admin = await prisma.user.upsert({
      where: { email: 'superadmin@healthguardian.com' },
      update: {
        password: adminPassword,
        role: 'super_admin',
      },
      create: {
        username: 'superadmin',
        password: adminPassword,
        email: 'superadmin@healthguardian.com',
        role: 'super_admin',
      },
    });
    console.log(`Created super_admin user: ${admin.email}`);
    console.log('Super admin credentials:');
    console.log('Email: superadmin@healthguardian.com');
    console.log('Password: admin123');

    // Create hospital user
    console.log('\nCreating hospital user...');
    const hospitalPassword = await hash('hospital123', 10);
    const hospitalUser = await prisma.user.upsert({
      where: { email: 'hospital@example.com' },
      update: {
        password: hospitalPassword,
        role: 'hospital',
        hospital_id: hospital1.id,
      },
      create: {
        username: 'hospital',
        password: hospitalPassword,
        email: 'hospital@example.com',
        role: 'hospital',
        hospital_id: hospital1.id,
      },
    });
    console.log(`Created hospital user: ${hospitalUser.email}`);
    console.log('Hospital user credentials:');
    console.log('Email: hospital@example.com');
    console.log('Password: hospital123');
    console.log(`Associated with hospital: ${hospital1.name} (ID: ${hospital1.id})`);

    console.log('\nDatabase initialization complete!');
    
  } catch (error) {
    console.error('Error initializing database:', error);
  } finally {
    await prisma.$disconnect();
  }
}

main(); 