const { PrismaClient } = require('@prisma/client');
const { hash } = require('bcryptjs');

const prisma = new PrismaClient();

async function main() {
  try {
    console.log('Creating new admin user...');
    
    // Create a simple password for testing
    const password = await hash('admin123', 10);
    
    // Create or update the admin user
    const admin = await prisma.user.upsert({
      where: { email: 'superadmin@healthguardian.com' },
      update: {
        password: password,
        role: 'super_admin',
      },
      create: {
        username: 'superadmin',
        email: 'superadmin@healthguardian.com',
        password: password,
        role: 'super_admin',
      },
    });
    
    console.log(`Admin user created/updated successfully: ${admin.email}`);
    console.log('Login credentials:');
    console.log('Email: superadmin@healthguardian.com');
    console.log('Password: admin123');
    
    // Create a hospital user
    const hospitalPassword = await hash('hospital123', 10);
    
    // Get the first hospital
    const hospital = await prisma.hospital.findFirst();
    
    if (hospital) {
      const hospitalUser = await prisma.user.upsert({
        where: { email: 'hospital@example.com' },
        update: {
          password: hospitalPassword,
          role: 'hospital',
          hospital_id: hospital.id,
        },
        create: {
          username: 'hospital',
          email: 'hospital@example.com',
          password: hospitalPassword,
          role: 'hospital',
          hospital_id: hospital.id,
        },
      });
      
      console.log(`Hospital user created/updated successfully: ${hospitalUser.email}`);
      console.log('Hospital user login credentials:');
      console.log('Email: hospital@example.com');
      console.log('Password: hospital123');
      console.log(`Associated with hospital: ${hospital.name} (ID: ${hospital.id})`);
    } else {
      console.log('No hospitals found in the database.');
    }
    
  } catch (error) {
    console.error('Error creating admin user:', error);
  } finally {
    await prisma.$disconnect();
  }
}

main(); 