const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

async function main() {
  try {
    console.log("Creating training events...");
    
    // First check if hospital exists
    const hospital = await prisma.hospital.findFirst();
    
    if (!hospital) {
      console.log("No hospital found. Please seed hospitals first.");
      return;
    }
    
    // Sample training events
    const trainingEvents = [
      {
        title: "HIPAA Compliance Workshop",
        date: new Date("2023-06-15"),
        instructor: "Dr. Sarah Johnson",
        location: "Conference Room A",
        department: "All Staff",
        duration: "3 hours",
        capacity: 30,
        enrolled: 22,
        required: true,
        hospital_id: hospital.id
      },
      {
        title: "Basic Life Support Training",
        date: new Date("2023-06-25"),
        instructor: "Dr. Michael Chen",
        location: "Simulation Lab",
        department: "Clinical Staff",
        duration: "4 hours",
        capacity: 15,
        enrolled: 12,
        required: true,
        hospital_id: hospital.id
      },
      {
        title: "Medical Records Documentation",
        date: new Date("2023-07-10"),
        instructor: "Emily Rodriguez",
        location: "Training Room B",
        department: "Administrative Staff",
        duration: "2 hours",
        capacity: 25,
        enrolled: 18,
        required: false,
        hospital_id: hospital.id
      },
      {
        title: "Patient Safety Protocols",
        date: new Date("2023-07-20"),
        instructor: "Dr. James Wilson",
        location: "Auditorium",
        department: "All Staff",
        duration: "2.5 hours",
        capacity: 50,
        enrolled: 32,
        required: true,
        hospital_id: hospital.id
      },
      {
        title: "Infection Control Procedures",
        date: new Date("2023-08-05"),
        instructor: "Dr. Lisa Taylor",
        location: "Conference Room C",
        department: "Clinical Staff",
        duration: "3 hours",
        capacity: 20,
        enrolled: 15,
        required: true,
        hospital_id: hospital.id
      }
    ];
    
    console.log("Clearing existing training events...");
    
    // Clear existing training events
    await prisma.trainingEvent.deleteMany({});
    
    console.log("Creating new training events...");
    
    // Create new training events
    for (const event of trainingEvents) {
      await prisma.trainingEvent.create({
        data: event
      });
    }
    
    console.log(`Created ${trainingEvents.length} training events.`);
  } catch (error) {
    console.error("Error creating training events:", error);
  } finally {
    await prisma.$disconnect();
  }
}

main(); 