import { PrismaClient } from '@prisma/client'

const prisma = new PrismaClient()

async function main() {
  try {
    console.log('🌱 Seeding document options...')

    // Seed Document Statuses
    const statuses = [
      {
        value: 'active',
        label: 'Active',
        description: 'Document is active and current',
        color_class: 'text-green-600 border-green-300',
        sort_order: 1
      },
      {
        value: 'review',
        label: 'Review Needed',
        description: 'Document requires review or updates',
        color_class: 'text-amber-600 border-amber-300',
        sort_order: 2
      },
      {
        value: 'archived',
        label: 'Archived',
        description: 'Document is archived and no longer current',
        color_class: 'text-gray-600 border-gray-300',
        sort_order: 3
      },
      {
        value: 'draft',
        label: 'Draft',
        description: 'Document is in draft status',
        color_class: 'text-blue-600 border-blue-300',
        sort_order: 4
      }
    ]

    for (const status of statuses) {
      await prisma.documentStatus.upsert({
        where: { value: status.value },
        update: status,
        create: status
      })
      console.log(`✅ Created/updated status: ${status.label}`)
    }

    console.log('🎉 Document options seeding completed!')

  } catch (error) {
    console.error('❌ Error seeding document options:', error)
    throw error
  } finally {
    await prisma.$disconnect()
  }
}

main()
  .catch((e) => {
    console.error(e)
    process.exit(1)
  }) 