/** @type {import('next').NextConfig} */
const nextConfig = {
  reactStrictMode: true,
  
  // Basic optimizations only
  experimental: {
    optimizePackageImports: ['@/components', '@/lib'],
  },
  
  // Simple compiler optimizations
  compiler: {
    removeConsole: process.env.NODE_ENV === 'production',
  },
  
  // Enable compression
  compress: true,
  
  // Basic image optimization
  images: {
    formats: ['image/webp'],
  },
  
  // Only essential headers
  async headers() {
    return [
      {
        source: '/_next/static/(.*)',
        headers: [
          {
            key: 'Cache-Control',
            value: 'public, max-age=31536000, immutable'
          }
        ],
      }
    ];
  },
};

module.exports = nextConfig; 