'use client'

import React from 'react';
import { useSelectedHospital } from '@/hooks/useSelectedHospital';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { BuildingIcon } from '@/components/ui/icons';

interface SelectHospitalMessageProps {
  title?: string;
  description?: string;
}

/**
 * Component that displays a message prompting super admins to select a hospital
 * Only shown for super admins when no hospital is selected
 * Regular hospital admins will never see this component
 */
export function SelectHospitalMessage({
  title = 'Hospital Selection Required',
  description = 'Please select a hospital from the dropdown in the top navigation bar to view data.'
}: SelectHospitalMessageProps) {
  const { isSuperAdmin, currentHospital } = useSelectedHospital();
  
  // Only show for super admins without a selected hospital
  if (!isSuperAdmin || currentHospital) {
    return null;
  }
  
  return (
    <Card className="mx-auto max-w-md">
      <CardHeader>
        <div className="flex items-center gap-2">
          <BuildingIcon className="h-5 w-5 text-primary" />
          <CardTitle>{title}</CardTitle>
        </div>
        <CardDescription>
          {description}
        </CardDescription>
      </CardHeader>
      <CardContent>
        <div className="flex items-center justify-center py-6">
          <div className="flex flex-col items-center text-sm text-muted-foreground">
            <div className="mb-2 flex h-12 w-12 items-center justify-center rounded-full bg-muted">
              <BuildingIcon className="h-6 w-6" />
            </div>
            <p>Use the hospital selector at the top of the page</p>
            <p>to choose which hospital's data to view and manage</p>
          </div>
        </div>
      </CardContent>
    </Card>
  );
} 