import React from 'react';
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import {
  FileCheck,
  BarChart,
  Calendar,
  Users,
  Award,
  AlertTriangle
} from "lucide-react";

interface TrainingMetricsProps {
  metrics: {
    upcomingEvents: number;
    avgCompletionRate: number;
    highPriorityModules: number;
    totalEvents: number;
    totalModules: number;
  };
}

export function TrainingMetrics({ metrics }: TrainingMetricsProps) {
  return (
    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
      <MetricCard
        title="Training Completion"
        description="Average completion rate"
        value={`${metrics.avgCompletionRate}%`}
        icon={<FileCheck className="h-5 w-5 text-primary" />}
      />
      
      <MetricCard
        title="Upcoming Events"
        description="Events in next 30 days"
        value={metrics.upcomingEvents.toString()}
        icon={<Calendar className="h-5 w-5 text-primary" />}
      />
      
      <MetricCard
        title="High Priority"
        description="Training modules"
        value={metrics.highPriorityModules.toString()}
        icon={<AlertTriangle className="h-5 w-5 text-primary" />}
      />
      
      <MetricCard
        title="Total Training"
        description="Events and modules"
        value={`${metrics.totalEvents + metrics.totalModules}`}
        icon={<Award className="h-5 w-5 text-primary" />}
      />
    </div>
  );
}

interface MetricCardProps {
  title: string;
  description: string;
  value: string;
  icon: React.ReactNode;
}

function MetricCard({ title, description, value, icon }: MetricCardProps) {
  return (
    <Card>
      <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
        <div className="space-y-1">
          <CardTitle className="text-sm font-medium">{title}</CardTitle>
          <CardDescription>{description}</CardDescription>
        </div>
        {icon}
      </CardHeader>
      <CardContent>
        <div className="text-2xl font-bold">{value}</div>
      </CardContent>
    </Card>
  );
} 