import { CircularProgressbar, buildStyles } from 'react-circular-progressbar';
import 'react-circular-progressbar/dist/styles.css';

interface CircularProgressProps {
  percentage: number;
  size?: 'sm' | 'md' | 'lg';
  showText?: boolean;
}

const CircularProgress = ({ percentage, size = 'md', showText = true }: CircularProgressProps) => {
  const getProgressColor = (percent: number) => {
    if (percent >= 90) return '#10b981'; // Green
    if (percent >= 75) return '#0ea5e9'; // Blue
    if (percent >= 50) return '#f59e0b'; // Amber
    return '#ef4444'; // Red
  };

  const sizeClasses = {
    sm: 'w-12 h-12',
    md: 'w-32 h-32',
    lg: 'w-40 h-40',
  };

  return (
    <div className={sizeClasses[size]}>
      <CircularProgressbar
        value={percentage}
        text={showText ? `${percentage}%` : undefined}
        styles={buildStyles({
          textSize: size === 'sm' ? '1.8rem' : '1rem',
          pathColor: getProgressColor(percentage),
          textColor: getProgressColor(percentage),
          trailColor: '#e5e7eb',
        })}
      />
    </div>
  );
};

export default CircularProgress; 