'use client'

import { useEffect } from 'react'
import { redirect } from 'next/navigation'

export default function Home() {
  useEffect(() => {
    // Check if user is logged in
    const isLoggedIn = localStorage.getItem('isLoggedIn') === 'true'
    
    if (isLoggedIn) {
      // Redirect to dashboard if logged in
      window.location.href = '/dashboard'
    } else {
      // Redirect to login if not logged in
      window.location.href = '/login'
    }
  }, [])
  
  // Show loading state while redirecting
  return (
    <div className="flex h-screen items-center justify-center">
      <p>Loading...</p>
    </div>
  )
}
