import { NextResponse } from 'next/server';
import prisma from '@/lib/prisma';
import { handleApiError } from '@/lib/api-helpers';

export async function GET() {
  try {
    const severities = await prisma.findingSeverity.findMany({
      where: { is_active: true },
      orderBy: { sort_order: 'asc' },
      select: {
        id: true,
        value: true,
        label: true,
        description: true,
        color_class: true,
        sort_order: true
      }
    });

    return NextResponse.json(severities);
  } catch (error) {
    return handleApiError(error);
  }
} 