import { NextRequest, NextResponse } from 'next/server';
import prisma from '@/lib/prisma';

export async function GET(request: NextRequest) {
  try {
    const reportTypes = await prisma.reportType.findMany({
      where: {
        is_active: true
      },
      orderBy: {
        label: 'asc'
      }
    });

    return NextResponse.json(reportTypes);
  } catch (error) {
    console.error('Error fetching report types:', error);
    return NextResponse.json(
      { error: 'Failed to fetch report types' },
      { status: 500 }
    );
  }
} 