import { NextRequest, NextResponse } from 'next/server';
import prisma from '@/lib/prisma';

export async function GET(request: NextRequest) {
  try {
    const statuses = await prisma.policyStatus.findMany({
      where: {
        is_active: true
      },
      orderBy: {
        label: 'asc'
      }
    });

    return NextResponse.json(statuses);
  } catch (error) {
    console.error('Error fetching policy statuses:', error);
    return NextResponse.json(
      { error: 'Failed to fetch policy statuses' },
      { status: 500 }
    );
  }
} 