// GET - fetch mock departments for testing
export async function GET(req: Request) {
  console.log('Department Test API - Returning mock data');
  
  // Mock data that matches the Department interface
  const mockDepartments = [
    {
      id: "1",
      name: "Nursing",
      description: "Nursing and patient care staff",
      hospital_id: 1,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString()
    },
    {
      id: "2",
      name: "Pharmacy",
      description: "Medication management and pharmacy services",
      hospital_id: 1,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString()
    },
    {
      id: "3",
      name: "Laboratory",
      description: "Medical testing and laboratory services",
      hospital_id: 1,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString()
    }
  ];
  
  // Use standard fetch Response object for simplicity
  return new Response(JSON.stringify({ departments: mockDepartments }), {
    headers: { 'Content-Type': 'application/json' }
  });
} 