'use client'

import React from "react"
import { 
  Card, 
  CardContent, 
  CardDescription, 
  CardHeader, 
  CardTitle 
} from "@/components/ui/card"
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs"
import { useScheduleData } from "@/hooks/useScheduleData"
import { AuditScheduleTab } from "@/components/schedule/AuditScheduleTab"
import { TrainingCalendarTab } from "@/components/schedule/TrainingCalendarTab"
import { RegulatoryDeadlinesTab } from "@/components/schedule/RegulatoryDeadlinesTab"
import { ResourcePlanningTab } from "@/components/schedule/ResourcePlanningTab"

export default function SchedulePage() {
  const {
    auditSchedules,
    trainingEvents,
    regulatoryDeadlines,
    resourceAllocations,
    loading,
    error,
    // CRUD operations
    createAuditSchedule,
    updateAuditSchedule,
    deleteAuditSchedule,
    createTrainingEvent,
    updateTrainingEvent,
    deleteTrainingEvent,
    createRegulatoryDeadline,
    updateRegulatoryDeadline,
    deleteRegulatoryDeadline,
    createResourceAllocation,
    updateResourceAllocation,
    deleteResourceAllocation,
    refreshAll
  } = useScheduleData();

  return (
    <div className="container mx-auto py-6">
      <div className="flex flex-col space-y-6">
        <div>
          <h1 className="text-3xl font-bold tracking-tight">Schedule</h1>
          <p className="text-muted-foreground">
            Manage audit schedules, training events, regulatory deadlines, and resource planning.
          </p>
        </div>

        <Card>
          <CardHeader>
            <CardTitle>Schedule Management</CardTitle>
            <CardDescription>
              View and manage your organization's schedule items.
            </CardDescription>
          </CardHeader>
          <CardContent>
            <Tabs defaultValue="audit-schedule" className="space-y-4">
              <TabsList className="grid grid-cols-4 gap-4">
                <TabsTrigger value="audit-schedule">Audit Schedule</TabsTrigger>
                <TabsTrigger value="training-calendar">Training Calendar</TabsTrigger>
                <TabsTrigger value="regulatory-deadlines">Regulatory Deadlines</TabsTrigger>
                <TabsTrigger value="resource-planning">Resource Planning</TabsTrigger>
              </TabsList>
              
              <TabsContent value="audit-schedule" className="space-y-4">
                <AuditScheduleTab 
                  auditSchedules={auditSchedules}
                  loading={loading.audits}
                  error={error.audits}
                  onAdd={createAuditSchedule}
                  onEdit={updateAuditSchedule}
                  onDelete={deleteAuditSchedule}
                />
              </TabsContent>
              
              <TabsContent value="training-calendar" className="space-y-4">
                <TrainingCalendarTab 
                  trainingEvents={trainingEvents}
                  loading={loading.training}
                  error={error.training}
                  onAdd={createTrainingEvent}
                  onEdit={updateTrainingEvent}
                  onDelete={deleteTrainingEvent}
                />
              </TabsContent>
              
              <TabsContent value="regulatory-deadlines" className="space-y-4">
                <RegulatoryDeadlinesTab
                  regulatoryDeadlines={regulatoryDeadlines}
                  loading={loading.deadlines}
                  error={error.deadlines}
                  onAdd={createRegulatoryDeadline}
                  onEdit={updateRegulatoryDeadline}
                  onDelete={deleteRegulatoryDeadline}
                />
              </TabsContent>
              
              <TabsContent value="resource-planning" className="space-y-4">
                <ResourcePlanningTab
                  resourceAllocations={resourceAllocations}
                  loading={loading.resources}
                  error={error.resources}
                  onAdd={createResourceAllocation}
                  onEdit={updateResourceAllocation}
                  onDelete={deleteResourceAllocation}
                />
              </TabsContent>
            </Tabs>
          </CardContent>
        </Card>
      </div>
    </div>
  )
} 