import React from 'react'
import type { Metadata } from "next";
import { redirect } from "next/navigation";
import { auth } from "@/lib/auth";
import { HospitalProvider } from '@/lib/context/HospitalContext'
import { UserProvider } from '@/lib/context/UserContext'
import DashboardClient from './dashboard-client'

export const metadata: Metadata = {
  title: "Dashboard | Health Audit System",
  description: "Health Audit System Dashboard",
};

export default async function DashboardLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  const session = await auth();

  if (!session) {
    redirect("/login");
  }

  return (
    <UserProvider>
      <HospitalProvider>
        <DashboardClient>
          {children}
        </DashboardClient>
      </HospitalProvider>
    </UserProvider>
  )
} 