'use client'

import { useEffect } from "react"
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs"
import ComplianceOverview from "@/components/compliance/ComplianceOverview"
import StandardsTab from "@/components/compliance/StandardsTab"
import ReportsTabContent from "@/components/compliance/ReportsTabContent"
import PoliciesTab from "@/components/compliance/PoliciesTab"

export default function CompliancePage() {
  useEffect(() => {
    document.title = "Compliance | Health Guardian"
  }, [])

  return (
    <div className="space-y-6 p-6">
      <h1 className="text-3xl font-bold">Compliance Management</h1>
      
      <Tabs defaultValue="overview" className="w-full">
        <TabsList>
          <TabsTrigger value="overview">Overview</TabsTrigger>
          <TabsTrigger value="standards">Standards</TabsTrigger>
          <TabsTrigger value="reports">Reports</TabsTrigger>
          <TabsTrigger value="policies">Policies</TabsTrigger>
        </TabsList>
        
        <TabsContent value="overview" className="space-y-4 mt-4">
          <ComplianceOverview />
        </TabsContent>
        
        <TabsContent value="standards" className="mt-4">
          <StandardsTab />
        </TabsContent>
        
        <TabsContent value="reports" className="mt-4">
          <ReportsTabContent />
        </TabsContent>
        
        <TabsContent value="policies" className="mt-4">
          <PoliciesTab />
        </TabsContent>
      </Tabs>
    </div>
  )
} 