'use client';

import { useState } from 'react';

export default function DirectLoginPage() {
  const [isLoading, setIsLoading] = useState(false);
  const [message, setMessage] = useState('');

  const handleDirectLogin = async () => {
    setIsLoading(true);
    setMessage('Attempting login...');
    
    try {
      // Use our custom API route
      const response = await fetch('/api/test-login');
      
      if (response.redirected) {
        // If the server has redirected us, follow the redirect
        window.location.href = response.url;
        return;
      }
      
      const data = await response.json();
      
      if (data.success) {
        setMessage('Login successful! Redirecting...');
        window.location.href = '/dashboard';
      } else {
        setMessage(`Login failed: ${data.message}`);
      }
    } catch (error) {
      setMessage(`Error: ${error instanceof Error ? error.message : 'Unknown error'}`);
    } finally {
      setIsLoading(false);
    }
  };

  return (
    <div className="flex flex-col items-center justify-center min-h-screen bg-gray-100 p-4">
      <div className="w-full max-w-md bg-white shadow-md rounded-lg p-8">
        <h1 className="text-2xl font-bold mb-6 text-center">Direct Login</h1>
        
        <p className="mb-6 text-center">
          This is a simplified login that bypasses NextAuth to help debug issues.
          Click the button below to log in as the superadmin user.
        </p>
        
        {message && (
          <div className="mb-4 p-3 rounded-md bg-blue-50 text-blue-700">
            {message}
          </div>
        )}
        
        <button 
          onClick={handleDirectLogin}
          disabled={isLoading}
          className="w-full py-2 px-4 bg-blue-600 text-white rounded-md hover:bg-blue-700 disabled:opacity-50"
        >
          {isLoading ? 'Logging in...' : 'Login as Superadmin'}
        </button>
      </div>
    </div>
  );
} 